function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/util/ScaledLayout
 */
define(['jquery', 'underscore', 'nmodule/bajaui/rc/util/pxUtils'], function ($, _, pxUtils) {
  'use strict';

  var isNumber = _.isNumber,
    getScrollBarWidth = pxUtils.getScrollBarWidth;

  /**
   * @typedef {object} module:nmodule/bajaui/rc/util/ScaledLayout~ScaledLayoutConfig
   * @property {number} [outerWidth] width of parent element. If omitted, will
   * be calculated according to scaling mode and outerHeight.
   * @property {number} [outerHeight] height of parent element. If omitted, will
   * be calculated according to scaling mode and outerWidth.
   * @property {number} innerWidth width of inner element
   * @property {number} innerHeight height of inner element
   * @property {string} scale scaling mode (a BScaleMode tag)
   * @property {number} [minScaleFactor=0] scaling minimum
   * @property {number} [maxScaleFactor=0] scaling maximum (0 means
   * unconstrained scaling up)
   * @property {string} halign how to horizontally align the child element (a
   * BHalign tag)
   * @property {string} valign how to vertically align the child element (a
   * BValign tag)
   * @property {boolean} [applyZoomOffsetWidth] If true, will
   * account for a scrollbar when using a zoom prefix scaling mode for width
   * @property {boolean} [applyZoomOffsetHeight] If true, will
   * account for a scrollbar when using a zoom prefix scaling mode for height
   */

  /**
   * This class is responsible for taking a child element and scaling it up to
   * its parent, taking into account scale mode, alignment, and min/max scale
   * factors. Primary use cases are CanvasPane and Picture.
   *
   * @alias module:nmodule/bajaui/rc/util/ScaledLayout
   */
  return /*#__PURE__*/function () {
    /**
     * @param {module:nmodule/bajaui/rc/util/ScaledLayout~ScaledLayoutConfig} config
     */
    function ScaledLayout(config) {
      _classCallCheck(this, ScaledLayout);
      this.$config = config;
    }

    /**
     * Gets the scale ratio in each direction.
     * @returns {{scaleX: number, scaleY: number}}
     */
    return _createClass(ScaledLayout, [{
      key: "getScale",
      value: function getScale() {
        return this.$scale || (this.$scale = toScale(this.$config));
      }

      /**
       * @returns {number} width of the inner element after scaling
       */
    }, {
      key: "getScaledWidth",
      value: function getScaledWidth() {
        return this.getScale().scaleX * this.$config.innerWidth;
      }

      /**
       * @returns {number} height of the inner element after scaling
       */
    }, {
      key: "getScaledHeight",
      value: function getScaledHeight() {
        return this.getScale().scaleY * this.$config.innerHeight;
      }

      /**
       * @returns {{transform: string, transform-origin: string}} CSS to apply
       * the scaling using CSS transforms, to be applied to the child element.
       * The parent element is still responsible for doing the actual alignment
       * of the child element.
       */
    }, {
      key: "getTransformCss",
      value: function getTransformCss() {
        var _this$$config = this.$config,
          halign = _this$$config.halign,
          valign = _this$$config.valign;
        var _this$getScale = this.getScale(),
          scaleX = _this$getScale.scaleX,
          scaleY = _this$getScale.scaleY;
        return {
          transform: "scale(".concat(scaleX, ", ").concat(scaleY, ")"),
          transformOrigin: alignToPercent(halign) + ' ' + alignToPercent(valign)
        };
      }

      /**
       * Scale an inner element to its outer container.
       *
       * @param {HTMLElement|JQuery} inner
       * @param {HTMLElement|JQuery} outer
       * @param {module:nmodule/bajaui/rc/util/ScaledLayout~ScaledLayoutConfig} config
       * @returns {module:nmodule/bajaui/rc/util/ScaledLayout}
       */
    }], [{
      key: "scale",
      value: function scale(inner, outer, config) {
        inner = $(inner);
        outer = $(outer);
        var outerWidth = outer.width();
        var outerHeight = outer.height();
        var container = outer.closest('.ux-scaled-layout-support');
        if (container.length) {
          if (container.hasClass('ux-scaled-layout-scale-to-width')) {
            outerHeight = undefined;
          } else if (container.hasClass('ux-scaled-layout-scale-to-height')) {
            outerWidth = undefined;
          }
        }
        return new ScaledLayout(Object.assign({
          outerWidth: outerWidth,
          outerHeight: outerHeight,
          innerWidth: inner.width(),
          innerHeight: inner.height()
        }, config));
      }
    }]);
  }();

  /**
   * @param {module:nmodule/bajaui/rc/util/ScaledLayout~ScaledLayoutConfig} config
   */
  function toScale(config) {
    var innerWidth = config.innerWidth,
      innerHeight = config.innerHeight,
      scale = config.scale,
      _config$minScaleFacto = config.minScaleFactor,
      min = _config$minScaleFacto === void 0 ? 0 : _config$minScaleFacto,
      _config$maxScaleFacto = config.maxScaleFactor,
      max = _config$maxScaleFacto === void 0 ? 0 : _config$maxScaleFacto,
      applyZoomOffsetWidth = config.applyZoomOffsetWidth,
      applyZoomOffsetHeight = config.applyZoomOffsetHeight;
    var _getOuterDimensions = getOuterDimensions(config),
      outerWidth = _getOuterDimensions.outerWidth,
      outerHeight = _getOuterDimensions.outerHeight,
      scrollBarWidth;
    if (max <= 0) {
      max = Number.POSITIVE_INFINITY;
    }
    var clamp = function clamp(num) {
      return Math.max(min, Math.min(num, max));
    };
    var scaleX, scaleY, ratioScale;
    var xRatio = outerWidth / innerWidth;
    var yRatio = outerHeight / innerHeight;
    if ((applyZoomOffsetWidth || applyZoomOffsetHeight) && scale.startsWith('zoom')) {
      scrollBarWidth = getScrollBarWidth();
      var positiveRatioDiff = Math.abs(xRatio - yRatio);
      if (positiveRatioDiff * innerWidth <= scrollBarWidth || positiveRatioDiff * innerHeight <= scrollBarWidth) {
        scale = 'fitRatio';
      }
    }
    switch (scale) {
      case 'none':
        scaleX = 1;
        scaleY = 1;
        break;
      case 'fit':
        scaleX = clamp(xRatio);
        scaleY = clamp(yRatio);
        break;
      case 'fitRatio':
        ratioScale = clamp(Math.min(xRatio, yRatio));
        scaleX = ratioScale;
        scaleY = ratioScale;
        break;
      case 'fitWidth':
        scaleX = clamp(xRatio);
        scaleY = 1;
        break;
      case 'fitHeight':
        scaleX = 1;
        scaleY = clamp(yRatio);
        break;
      case 'zoomRatio':
        ratioScale = clamp(Math.max(xRatio, yRatio));
        scaleX = ratioScale;
        scaleY = ratioScale;
        if (applyZoomOffsetWidth || applyZoomOffsetHeight) {
          if (innerWidth * scaleX > outerWidth || innerHeight * scaleY > outerHeight) {
            scrollBarWidth = getScrollBarWidth();
            if (xRatio > yRatio && applyZoomOffsetWidth) {
              ratioScale = clamp(xRatio) - scrollBarWidth / innerWidth;
            } else if (xRatio <= yRatio && applyZoomOffsetHeight) {
              ratioScale = clamp(yRatio) - scrollBarWidth / innerHeight;
            }
            scaleX = ratioScale;
            scaleY = ratioScale;
          }
        }
        break;
      case 'zoomWidth':
        ratioScale = clamp(xRatio);
        scaleX = ratioScale;
        scaleY = ratioScale;
        if (applyZoomOffsetWidth && (innerWidth * scaleX > outerWidth || innerHeight * scaleY > outerHeight)) {
          scrollBarWidth = getScrollBarWidth();
          ratioScale = clamp(xRatio) - scrollBarWidth / innerWidth;
          scaleX = ratioScale;
          scaleY = ratioScale;
        }
        break;
      case 'zoomHeight':
        ratioScale = clamp(yRatio);
        scaleX = ratioScale;
        scaleY = ratioScale;
        if (applyZoomOffsetHeight && (innerWidth * scaleX > outerWidth || innerHeight * scaleY > outerHeight)) {
          scrollBarWidth = getScrollBarWidth();
          ratioScale = clamp(yRatio) - scrollBarWidth / innerHeight;
          scaleX = ratioScale;
          scaleY = ratioScale;
        }
        break;
    }
    return {
      scaleX: scaleX,
      scaleY: scaleY
    };
  }
  function getOuterDimensions(config) {
    var innerWidth = config.innerWidth,
      innerHeight = config.innerHeight,
      scale = config.scale;
    var outerWidth = config.outerWidth,
      outerHeight = config.outerHeight;
    var hasWidth = isNumber(outerWidth);
    var hasHeight = isNumber(outerHeight);
    if (hasWidth && hasHeight) {
      // we already have them
      return {
        outerWidth: outerWidth,
        outerHeight: outerHeight
      };
    }
    if (!hasWidth && !hasHeight) {
      // perform no scaling as we have nothing to scale to
      return {
        outerWidth: innerWidth,
        outerHeight: innerHeight
      };
    }
    switch (scale) {
      case 'none':
        outerWidth = innerWidth;
        outerHeight = innerHeight;
        break;
      case 'zoomRatio':
      case 'zoomWidth':
      case 'zoomHeight':
      case 'fitRatio':
        if (hasWidth) {
          outerHeight = outerWidth / innerWidth * innerHeight;
        } else {
          outerWidth = outerHeight / innerHeight * innerWidth;
        }
        break;
      case 'fit':
      case 'fitWidth':
      case 'fitHeight':
        if (hasWidth) {
          outerHeight = innerHeight;
        } else {
          outerWidth = innerWidth;
        }
        break;
    }
    return {
      outerWidth: outerWidth,
      outerHeight: outerHeight
    };
  }

  /**
   * @param {string} align a BHalign or BValign tag
   * @returns {string} percentage string for use in `transform-origin`
   */
  function alignToPercent(align) {
    switch (align) {
      case 'left':
      case 'top':
        return '0';
      case 'center':
      default:
        return '50%';
      case 'right':
      case 'bottom':
      case 'fill':
        return '100%';
    }
  }
});
