function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam and JJ Frankovich
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Label
 */
define(['baja!', 'baja!bajaui:Align,bajaui:Halign,bajaui:Valign,gx:Size,gx:Image,gx:Brush,gx:Font,gx:Insets', 'bajaux/icon/iconUtils', 'bajaux/spandrel', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, iconUtils, spandrel, pxUtils, IconEditor, htmlUtils) {
  'use strict';

  var escapeHtml = htmlUtils.escapeHtml;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Label',
        enabled: true,
        visible: true,
        text: "",
        image: baja.$('gx:Image', 'null'),
        margin: baja.$('gx:Insets', 0),
        font: baja.$('gx:Font', 'null'),
        foreground: baja.$('gx:Brush', 'null'),
        background: baja.$('gx:Brush', 'null'),
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        textToIconAlign: baja.$('bajaui:Align', 'right'),
        textIconGap: 4,
        blink: false,
        wordWrapEnabled: false
      }
    };
  };

  //TODO: handle font facets with themes (NCCB-41325, NCCB-31016) as part of upcoming NCCB-45823

  /**
   * Label is a Widget for bajaui:Label.
   * Label supports an addition web property called `margin` of type `gx:Inset` that defaults to `0`.
   * A non-zero margin is added to the container element for the `text` and `image`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Label
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function Label(params) {
      _classCallCheck(this, Label);
      return _callSuper(this, Label, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(Label, _spandrel);
    return _createClass(Label, [{
      key: "$getLabelElement",
      value: function $getLabelElement() {
        return this.jq();
      }
    }, {
      key: "$getIconEditor",
      value: function $getIconEditor() {
        return this.queryWidget('0/image');
      }
    }, {
      key: "$getTextWidget",
      value: function $getTextWidget() {
        return this.queryWidget('0/text');
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        // Apply background to the label
        var label = this.$getLabelElement();
        var props = this.properties();
        var labelEl = label[0];
        var background = props.getValue('background');
        background.applyBackgroundToElement(labelEl);

        // Apply foreground to the text inside the label
        var textWidget = this.$getTextWidget();
        if (textWidget) {
          var textSpanEl = textWidget.jq()[0];
          var foreground = props.getValue('foreground');
          var enabled = this.isEnabled();
          if (enabled && foreground) {
            foreground.applyForegroundToElement(textSpanEl);
          }
        }
        var iconEditor = this.$getIconEditor();
        return iconEditor && iconEditor.dimensions();
      }
    }]);
  }(spandrel(function (model, _ref) {
    var props = _ref.props,
      rootElement = _ref.rootElement;
    var background = props.background,
      foreground = props.foreground,
      font = props.font,
      text = props.text,
      halign = props.halign,
      valign = props.valign,
      image = props.image,
      textIconGap = props.textIconGap,
      textToIconAlign = props.textToIconAlign,
      wordWrapEnabled = props.wordWrapEnabled,
      blink = props.blink,
      enabled = props.enabled,
      visible = props.visible,
      margin = props.margin;
    var imageOrds = image.getOrdList().getOrds();
    var label = rootElement;
    var style = label.style;
    background.applyBackgroundToElement(label);
    if (!wordWrapEnabled) {
      //note that the word wrap in Wb/Hx moves down to the next line on different words than Ux
      style.whiteSpace = "nowrap";
    }
    var div = document.createElement('div');
    div.classList.add("ux-Label-content");
    if (margin && margin.isVisible()) {
      margin.applyMarginToElement(div);
    }
    label.style.justifyContent = toHAlign(halign.getTag());
    var textSpan = document.createElement('span');
    textSpan.innerText = text;
    textSpan.classList.add('-t-Label-text');
    //required for multi line text
    textSpan.style.textAlign = toHAlignForText(halign.getTag());
    font.applyToElement(textSpan);
    if (enabled) {
      foreground.applyForegroundToElement(textSpan);
    }
    var textToIconAlignTag = textToIconAlign.getTag();
    var isCentered = textToIconAlignTag === 'center';
    div.style.flexDirection = toFlexDirection(textToIconAlignTag);
    var imageKid;
    if (imageOrds.length) {
      var imageSpan;
      imageSpan = document.createElement('span');
      imageSpan.classList.add('-t-Label-image');
      if (text && isCentered) {
        var imageUri = iconUtils.toUris(imageOrds)[0];
        div.style.backgroundImage = 'url("' + escapeHtml(imageUri) + '")';
        div.classList.add('-t-Label-textToIconAlignCenter');
        var img = new Image();
        img.onload = function () {
          // the divContent we create not guaranteed to live in DOM due to diffing
          var divContent = rootElement.querySelector('.ux-Label-content');
          if (!divContent) {
            return;
          }
          divContent.style.minWidth = img.width + "px";
          divContent.style.minHeight = img.height + "px";
          //Note: when textToIconAlignTag='center, image will not have 50% opacity yet. This doesn't seem to be that common.
        };
        img.src = imageUri;
      } else {
        if (text) {
          toTextAlignMargin(imageSpan.style, textToIconAlignTag, textIconGap);
        }
        imageKid = {
          dom: imageSpan,
          type: IconEditor,
          value: imageOrds,
          properties: {
            imageErrorBehavior: 'hide',
            draggable: false
          }
        };
      }
    }
    label.style.alignItems = toVAlign(valign.getTag());
    pxUtils.updateBlink([label], blink && visible);
    var kids = {};
    if (imageKid) {
      kids.image = imageKid;
    }
    kids.text = textSpan;
    return [{
      dom: div,
      kids: kids
    }];
  }));

  /**
   * Horizontal positioning based on css changes to `justifyContent`
   * @param {String} tag
   * @return {String}
   */
  function toHAlign(tag) {
    switch (tag) {
      case 'center':
      case 'fill':
        return 'center';
      case 'left':
        return 'flex-start';
      case 'right':
        return 'flex-end';
    }
  }

  /**
   * Horizontal positioning based on css changes to `textAlign`
   * @param {String} tag
   * @return {String}
   */
  function toHAlignForText(tag) {
    switch (tag) {
      case 'center':
      case 'fill':
        return 'center';
      case 'left':
      case 'right':
        return tag;
    }
  }

  /**
   * Horizontal positioning based on css changes to `flexDirection`
   * @param {String} tag
   * @return {string}
   */
  function toFlexDirection(tag) {
    switch (tag) {
      case 'top':
        return "column-reverse";
      case 'left':
        return 'row-reverse';
      case 'bottom':
        return "column";
      case 'right':
        return 'row';
      case 'center':
        return "";
      //this is handled by making the image the text background
    }
  }

  /**
   * When icon and text are present provide the appropriate margin to separate them.
   * @param {Object} style
   * @param {String} tag
   * @param {Number} textIconGap
   */
  function toTextAlignMargin(style, tag, textIconGap) {
    switch (tag) {
      case 'top':
        style.marginTop = textIconGap + "px";
        return;
      case 'left':
        style.marginLeft = textIconGap + "px";
        return;
      case 'bottom':
        style.marginBottom = textIconGap + "px";
        return;
      case 'right':
        style.marginRight = textIconGap + "px";
    }
  }

  /**
   * Vertical position based on css change to `alignItems`.
   * @param {String} tag
   * @return {String}
   */
  function toVAlign(tag) {
    switch (tag) {
      case 'fill':
      case 'center':
        return 'center';
      case 'top':
        return 'flex-start';
      case 'bottom':
        return 'flex-end';
    }
  }
});
