function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/SplitPane
 */
define(['baja!', 'baja!bajaui:Orientation,bajaui:NullWidget', 'bajaux/spandrel', 'bajaux/Widget', 'underscore', 'nmodule/js/rc/jquery/split-pane/split-pane', 'css!nmodule/bajaui/rc/bajaui', 'css!nmodule/js/rc/jquery/split-pane/split-pane'], function (baja, types, spandrel, Widget, _) {
  'use strict';

  var NULL_WIDGET = baja.$("bajaui:NullWidget");
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-SplitPane',
        widget1: NULL_WIDGET,
        widget2: NULL_WIDGET,
        dividerWidth: 6,
        moveableDivider: true,
        dividerPosition: 50,
        orientation: baja.$("bajaui:Orientation", "horizontal"),
        continuousLayout: true
      }
    };
  };
  var LAYOUT_FPS = 30;

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/SplitPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function SplitPane(params) {
      _classCallCheck(this, SplitPane);
      return _callSuper(this, SplitPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(SplitPane, _spandrel);
    return _createClass(SplitPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.on('splitpaneresize', _.throttle(function () {
          return _this.layout();
        }, 1000 / LAYOUT_FPS, {
          leading: false
        }));
        return _superPropGet(SplitPane, "doInitialize", this, 3)(arguments);
      }

      /**
       * When a property changes, a spandrel widget will trigger a re-render and
       * re-layout - so we can sock away values for use on the next layout.
       */
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === "orientation") {
          // restore user-placed position after the orientation flip
          this.$nextDividerPosition = this.$currentDividerPosition();
        } else if (name === 'dividerPosition') {
          // overwrite user-placed position with current property
          this.$nextDividerPosition = this.$configuredDividerPosition();
        }
        return _superPropGet(SplitPane, "doChanged", this, 3)([name, value]);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var el = this.jq()[0];
        if (!(el && document.contains(el))) {
          // split-pane relies on client dimension calculations that do not work when the element is detached
          return;
        }
        var $nextDividerPosition = this.$nextDividerPosition;
        if (!this.$spInstalled) {
          this.$initSplitPane();
          this.$spInstalled = true;
        }
        if (typeof $nextDividerPosition === 'number') {
          this.$moveDivider($nextDividerPosition);
        }
        delete this.$nextDividerPosition;
      }

      /**
       * @private
       * @param {number} percent where to move the divider to, as percent ([0-1])
       */
    }, {
      key: "$moveDivider",
      value: function $moveDivider(percent) {
        var splitPaneJq = this.$getSplitPaneJq();
        splitPaneJq.children().css(this.$isHorizontalLayout() ? 'height' : 'width', '');
        splitPaneJq.splitPane('firstComponentSize', this.$getSize() * percent - this.$getDividerWidth() / 2);
      }

      /**
       * @private
       * @returns {boolean} if the SplitPane is currently in horizontal layout
       * (widgets on left and right of divider). This must query the DOM because
       * it's used for layout calculations and may be called out of sync with the
       * widget's current Properties.
       */
    }, {
      key: "$isHorizontalLayout",
      value: function $isHorizontalLayout() {
        return this.$getSplitPaneJq().hasClass('vertical-percent');
      }

      /**
       * @private
       * @returns {number} divider position as configured on the widget, as
       * percent ([0-1])
       */
    }, {
      key: "$configuredDividerPosition",
      value: function $configuredDividerPosition() {
        return this.properties().getValue('dividerPosition') / 100;
      }

      /**
       * @private
       * @returns {number} divider position as currently placed by the user, as
       * percent ([0-1])
       */
    }, {
      key: "$currentDividerPosition",
      value: function $currentDividerPosition() {
        var divider = this.$getSplitPaneJq().children('.-t-SplitPane-divider')[0];
        if (!divider) {
          // no value loaded yet, so DOM has not been built yet, which means there is no slider for
          // the user to move. default to the position configured via widget properties.
          // as of NCCB-56408, this should no longer happen.
          return this.$configuredDividerPosition();
        }
        var dividerPosition = this.$isHorizontalLayout() ? divider.offsetLeft : divider.offsetTop;
        var dividerMidpoint = dividerPosition + this.$getDividerWidth() / 2;
        return dividerMidpoint / this.$getSize();
      }

      /**
       * @private
       * @returns {number} configured divider width in pixels
       */
    }, {
      key: "$getDividerWidth",
      value: function $getDividerWidth() {
        return this.properties().getValue('dividerWidth');
      }

      /**
       * @private
       * @returns {number} current width or height of the SplitPane (depending on
       * whether it is in horizontal or vertical layout), in pixels
       */
    }, {
      key: "$getSize",
      value: function $getSize() {
        var splitPaneJq = this.$getSplitPaneJq();
        return this.$isHorizontalLayout() ? splitPaneJq.width() : splitPaneJq.height();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSplitPaneJq",
      value: function $getSplitPaneJq() {
        return this.jq().children(".-t-SplitPane-inner");
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidget1",
      value: function $getWidget1() {
        return this.queryWidget('wrapper/pane1/widget');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidget2",
      value: function $getWidget2() {
        return this.queryWidget('wrapper/pane2/widget');
      }

      /**
       * One-time setup of split-pane plugin
       * @private
       */
    }, {
      key: "$initSplitPane",
      value: function $initSplitPane() {
        this.$getSplitPaneJq().splitPane();
        this.$moveDivider(this.$configuredDividerPosition());
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var orientation = properties.orientation,
      dividerWidth = properties.dividerWidth,
      moveableDivider = properties.moveableDivider,
      isHorizontal = orientation.getTag() === "horizontal",
      orientationClass = isHorizontal ? "vertical-percent" : "horizontal-percent",
      splitPaneClasses = "-t-SplitPane-inner split-pane ".concat(orientationClass),
      widget1 = model.get('widget1'),
      widget2 = model.get('widget2'),
      moveableDividerClass = moveableDivider ? "" : "-t-SplitPane-divider-not-moveable";
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: splitPaneClasses
    }, spandrel.jsx("div", {
      spandrelKey: "pane1",
      className: "split-pane-component",
      style: _defineProperty({}, isHorizontal ? 'marginRight' : 'marginBottom', "".concat(dividerWidth, "px"))
    }, widget1 && spandrel.jsx("div", {
      className: "-t-SplitPane-kid -t-SplitPane-widget1",
      spandrelKey: "widget",
      spandrelSrc: widget1
    })), spandrel.jsx("div", {
      className: "split-pane-divider -t-SplitPane-divider ".concat(moveableDividerClass),
      style: _defineProperty({}, isHorizontal ? 'width' : 'height', "".concat(dividerWidth, "px")),
      spandrelKey: "divider"
    }), spandrel.jsx("div", {
      spandrelKey: "pane2",
      className: "split-pane-component"
    }, widget2 && spandrel.jsx("div", {
      className: "-t-SplitPane-kid -t-SplitPane-widget1",
      spandrelKey: "widget",
      spandrelSrc: widget2
    })));
  }));
});
