function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/PhotoIdCamera
 */
define(['baja!', 'bajaux/Widget', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'bajaux/mixin/subscriberMixIn', 'nmodule/entsecHx/rc/photoID/rpc/rpc', 'css!nmodule/entsecHx/rc/entsecHx'], function (baja, Widget, Promise, BaseEditor, subscriberMixin, rpc) {
  'use strict';

  var DEFAULT_IMAGE_PATH = '/module/entsec/rc/silhoutteImage.PNG';

  var tpl = function tpl() {
    return "<img class=\"personImg\" />\n                     <div class=\"swipeDetails\" />";
  };
  /**
   * Class to show the PhotoIdCamera view.
   *
   ** API Status: **Private**
   * @class
   * @alias module:nmodule/entsecHx/rc/photoID/PhotoIdCamera
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */


  var PhotoIdCamera = /*#__PURE__*/function (_BaseEditor) {
    _inherits(PhotoIdCamera, _BaseEditor);

    var _super = _createSuper(PhotoIdCamera);

    function PhotoIdCamera(params) {
      var _this;

      _classCallCheck(this, PhotoIdCamera);

      _this = _super.call(this, params);
      subscriberMixin(_assertThisInitialized(_this));
      _this.$isMonitorNotInitialized = true;
      return _this;
    }

    _createClass(PhotoIdCamera, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('PhotoIdCamera');
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this2 = this;

        var that = this;
        return this.$initMonitor().then(function (args) {
          _this2.$isMonitorNotInitialized = false;

          var readerObj = _this2.$getReaderInfo();

          value.attach('changed', function (prop) {
            that.$changeHandler(this, prop)["catch"](baja.error);
          }); // Set the swipe details text.

          var photoIdNw = args[2];
          var fontSize = photoIdNw.getPhotoIDFontSize() || 12;

          var swipeDetailsElem = _this2.$getSwipeDetailsElement();

          swipeDetailsElem.css('font-size', fontSize);
          swipeDetailsElem.text(readerObj.swipeDetails); // Set the aspect ratio of the image.

          _this2.$fitImageForAspectRatio(photoIdNw.getDefaultImageRatio()); // Portrait ord handling.
          // Set the default image if the portrait ord is null.


          var portraitOrd = readerObj.portraitOrd;

          if (portraitOrd.isNull()) {
            _this2.$setDefaultImage();
          } else {
            return _this2.$setImageFromBytes(portraitOrd);
          }
        });
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getSwipeDetailsElement",
      value: function $getSwipeDetailsElement() {
        return this.jq().find('.swipeDetails');
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$initMonitor",
      value: function $initMonitor() {
        var navOrd = this.value().getNavOrd(); // Monitor to be initialized once per load.

        if (this.$isMonitorNotInitialized) {
          return Promise.all([rpc.monitorDoorRpc(navOrd), rpc.keepAliveMonitorRPC(navOrd), rpc.getOrd('service:entsec:PhotoIDNetwork', {
            lease: true
          })]);
        }

        return Promise.resolve();
      }
      /**
       * @private
       * @param {entsec.PhotoIdCamera} comp
       * @param {Property} prop
       * @returns {Promise}
       */

    }, {
      key: "$changeHandler",
      value: function $changeHandler(comp, prop) {
        var slotName = comp.getSlot(prop).getName();

        if (slotName === 'portraitOrd') {
          if (comp.get(prop).isNull()) {
            this.$setDefaultImage();
          } else {
            return this.$setImageFromBytes();
          }
        }

        if (slotName === 'swipeDetails') {
          this.jq().find('.swipeDetails').text(comp.get(prop));
        }

        return Promise.resolve();
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$setImageFromBytes",
      value: function $setImageFromBytes() {
        var _this3 = this;

        return rpc.getImageBytes(this.value().getNavOrd()).then(function (byteString) {
          if (byteString.length === 0) {
            _this3.$setDefaultImage();
          } else {
            var mimeType = _this3.$getImageType(_this3.value().getPortraitOrd().encodeToString());

            if (mimeType.length === 0) {
              _this3.$setDefaultImage();
            } else {
              _this3.jq().find('.personImg').attr('src', "data:image/".concat(mimeType, ";base64,") + byteString);
            }
          }
        });
      }
      /**
       * Adjusts the image as per the aspect ratio.
       *
       * @private
       * @param {entsec.PaperRatio} aspectRatio
       */

    }, {
      key: "$fitImageForAspectRatio",
      value: function $fitImageForAspectRatio(aspectRatio) {
        var width = this.jq().width();
        var height = this.jq().height();
        var imageElement = this.$getImageElement();
        var widthAndHeight = this.$getWidthAndHeightByAspectRatio(aspectRatio, {
          width: width,
          height: height
        });
        imageElement.hide();
        imageElement.width(widthAndHeight.width);
        imageElement.height(widthAndHeight.height);
        imageElement.show();
      }
      /**
       * Returns the width and height adjusted by the aspect ratio.
       *
       * @private
       * @param {entsec.PaperRatio} aspectRatio
       * @param {Number} width
       * @param {Number} height
       * @returns {{width: Number, height: Number}}
       */

    }, {
      key: "$getWidthAndHeightByAspectRatio",
      value: function $getWidthAndHeightByAspectRatio(aspectRatio, _ref) {
        var width = _ref.width,
            height = _ref.height;
        var ratio = this.$getAspectRatioByTag(aspectRatio);
        var fitWidth = width;
        var fitHeight = height;

        if (ratio) {
          if (height && !width) {
            fitWidth = height * ratio;
          } else if (width && !height) {
            fitHeight = width / ratio;
          } else {
            fitHeight = width / ratio;

            if (fitHeight > height) {
              fitWidth = height * ratio;
              fitHeight = height;
            }
          }
        }

        return {
          width: Math.floor(fitWidth),
          height: Math.floor(fitHeight)
        };
      }
      /**
       * @private
       * @param {entsec.PaperRatio} tag
       * @returns {Number}
       */

    }, {
      key: "$getAspectRatioByTag",
      value: function $getAspectRatioByTag(tag) {
        tag = String(tag);

        switch (tag) {
          case '3:4':
            return 3 / 4;

          case '4:3':
            return 4 / 3;

          case '16:9':
            return 16 / 9;

          case '9:16':
            return 9 / 16;

          case '0:0':
            return 1;

          default:
            return 1;
        }
      }
      /**
       * @private
       * @param {string} imageOrd
       * @returns {string}
       */

    }, {
      key: "$getImageType",
      value: function $getImageType(imageOrd) {
        if (imageOrd.indexOf('.jpg') !== -1) {
          return 'jpeg';
        } else if (imageOrd.indexOf('.png') !== -1) {
          return 'png';
        }

        return '';
      }
      /**
       * @private
       * @returns {{portraitOrd: baja.Ord, swipeDetails: string}}
       */

    }, {
      key: "$getReaderInfo",
      value: function $getReaderInfo() {
        return {
          portraitOrd: this.value().getPortraitOrd(),
          swipeDetails: this.value().getSwipeDetails()
        };
      }
      /**
       * @private
       */

    }, {
      key: "$setDefaultImage",
      value: function $setDefaultImage() {
        this.$getImageElement().attr('src', DEFAULT_IMAGE_PATH);
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getImageElement",
      value: function $getImageElement() {
        return this.jq().find('.personImg');
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PhotoIdCamera');
      }
    }]);

    return PhotoIdCamera;
  }(BaseEditor);

  return PhotoIdCamera;
});
