function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/onCall/rc/wb/UxOnCallUserReportView
 */
define(['baja!', 'baja!baja:AbsTimeRange', 'lex!onCall', 'bajaux/spandrel', 'dialogs', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/ComponentTableModel'], function (baja, types, lexs, spandrel, dialogs, Promise, feDialogs, Table, ComponentTableModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    onCallLex = _lexs[0];

  /*
   * hold this as a "static" value.
   * this isn't a great pattern because multiple instances of the view would fight over it.
   * but this is an affordance to the user to stop the range from resetting to "one month" as they
   * view the report view from one user to the next.
   * we would otherwise have to do something like MgrState just for this view. not worth it.
   */
  var lastEnteredRange = baja.$('baja:AbsTimeRange', {
    startTime: baja.AbsTime.now(),
    endTime: baja.AbsTime.now().nextMonth()
  });
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-UxOnCallUserReportView ux-fullscreen'
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/onCall/rc/wb/UxOnCallUserReportView
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var UxOnCallUserReportView = /*#__PURE__*/function (_spandrel) {
    function UxOnCallUserReportView(params) {
      _classCallCheck(this, UxOnCallUserReportView);
      return _callSuper(this, UxOnCallUserReportView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(UxOnCallUserReportView, _spandrel);
    return _createClass(UxOnCallUserReportView, [{
      key: "toState",
      value: function toState() {
        return {
          absTimeRange: lastEnteredRange
        };
      }

      /**
       * TODO: NCCB-62120
       * the right/expected thing would be onUxModify={() => false} on the AbsTimeRangeEditor
       */
    }, {
      key: "setModified",
      value: function setModified() {}

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAbsTimeRangeEditor",
      value: function $getAbsTimeRangeEditor() {
        return this.queryWidget('absTimeRange');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} Table if the OnCallService was queried successfully;
       * otherwise error message
       */
    }, {
      key: "$getContent",
      value: function $getContent() {
        return this.queryWidget('content');
      }

      /**
       * Retrieve the TableModel to load into the main content table. If this rejects, the error
       * message will be shown in place of the table.
       * @private
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/model/TableModel>}
       */
    }, {
      key: "$retrieveTableModel",
      value: function $retrieveTableModel() {
        var _this$state = this.state(),
          absTimeRange = _this$state.absTimeRange;
        var start = absTimeRange.get('startTime');
        var end = absTimeRange.get('endTime');
        if (end < start) {
          return Promise.reject(new Error(onCallLex.get('userReport.startEndTimeError')));
        }
        var ord = baja.Ord.make('h:' + this.value().getHandle());
        var value = baja.$('baja:Component', {
          ord: ord,
          start: start,
          end: end
        });
        var resolvePromise = this.$resolveOnCallService().then(function (service) {
          return service.invoke({
            slot: 'createUserReport',
            value: value
          });
        })["catch"](showAndBlank).then(function (results) {
          return ComponentTableModel.$makeBasic(results, 'onCall:OnCallContactUserEventInfo');
        });
        dialogs.showLoading(500, resolvePromise);
        return resolvePromise;
      }

      /**
       * @private
       * @returns {Promise.<baja.Component>} resolves to the `onCall:OnCallService`
       */
    }, {
      key: "$resolveOnCallService",
      value: function $resolveOnCallService() {
        // no need for spaceUtils because this view does not work offline
        return baja.Ord.make('service:onCall:OnCallService').get();
      }
    }]);
  }(spandrel(function (onCallContact, _ref) {
    var absTimeRange = _ref.absTimeRange,
      self = _ref.self;
    var absTimeRangeEditor = spandrel.jsx("any", {
      bind: true,
      spandrelKey: "absTimeRange",
      className: "-t-UxOnCallUserReportView-absTimeRange ux-fixed-header",
      value: absTimeRange,
      properties: {
        showLabels: true,
        showTime: false,
        showTimeZone: false
      },
      onUxModifiedValue: function onUxModifiedValue(range) {
        lastEnteredRange = range;
      }
    });
    return self.$retrieveTableModel().then(function (tableModel) {
      return spandrel.jsx(Table, {
        spandrelKey: "content",
        className: "ux-body",
        value: tableModel
      });
    })["catch"](function (err) {
      return spandrel.jsx("label", {
        spandrelKey: "content"
      }, err.message);
    }).then(function (content) {
      return [absTimeRangeEditor, content];
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * Show the error to the user and throw a blank error so the view blanks itself out in response.
   * @param {Error} err
   */
  function showAndBlank(err) {
    feDialogs.error(err, {
      title: onCallLex.get('userReport.reportError'),
      messageSummary: onCallLex.get('userReport.errorCouldNotLoad')
    });
    throw new Error('');
  }
  return UxOnCallUserReportView;
});
