function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/onCall/rc/wb/model/OnCallContactManagerModel
 */

define(['baja!', 'baja!onCall:OnCallContact', 'lex!onCall', 'Promise', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, types, lexs, Promise, MgrTypeInfo, MgrModel, IconMgrColumn, NameMgrColumn, PathMgrColumn, PropertyMgrColumn, Column, ContainerComponentSource) {
  'use strict';

  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    READONLY = _Column$flags.READONLY,
    UNSEEN = _Column$flags.UNSEEN;
  var ON_CALL_CONTACT_TYPE = baja.lt('onCall:OnCallContact');
  var _lexs = _slicedToArray(lexs, 1),
    ON_CALL_LEXS = _lexs[0];

  /**
   * MgrColumn for converting an Ord to a display value
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn
   */
  var OrdMgrColumn = /*#__PURE__*/function (_PropertyMgrColumn) {
    function OrdMgrColumn() {
      _classCallCheck(this, OrdMgrColumn);
      return _callSuper(this, OrdMgrColumn, arguments);
    }
    _inherits(OrdMgrColumn, _PropertyMgrColumn);
    return _createClass(OrdMgrColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var subjectOrd = row.getSubject().get(this.getName());
        if (!subjectOrd.isNull()) {
          var handle = subjectOrd.encodeToString();
          var ord = baja.Ord.make('station:|' + handle);
          return ord.get().then(function (results) {
            dom.text(results.getDisplayName());
          })["catch"](function () {
            dom.text(ON_CALL_LEXS.get('null'));
          });
        } else {
          dom.text(ON_CALL_LEXS.get('null'));
        }
      }
    }]);
  }(PropertyMgrColumn);
  var COLUMNS = [new IconMgrColumn(), new PathMgrColumn({
    flags: UNSEEN
  }), new NameMgrColumn({
    flags: EDITABLE | READONLY
  }), new PropertyMgrColumn('status', {
    type: ON_CALL_CONTACT_TYPE,
    flags: READONLY
  }), new PropertyMgrColumn('enabled', {
    type: ON_CALL_CONTACT_TYPE,
    flags: EDITABLE
  }), new PropertyMgrColumn('priority', {
    type: ON_CALL_CONTACT_TYPE,
    flags: EDITABLE
  }), new OrdMgrColumn('user', {
    type: ON_CALL_CONTACT_TYPE,
    flags: EDITABLE
  }), new OrdMgrColumn('userAlarmRecipient', {
    type: ON_CALL_CONTACT_TYPE,
    flags: EDITABLE
  }), new PropertyMgrColumn('rotationMarker', {
    type: ON_CALL_CONTACT_TYPE,
    flags: READONLY | UNSEEN
  })];

  /**
   * Model for the OnCallContact manager
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/onCall/rc/wb/model/OnCallContactManagerModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  return /*#__PURE__*/function (_MgrModel) {
    function OnCallContactManagerModel() {
      _classCallCheck(this, OnCallContactManagerModel);
      return _callSuper(this, OnCallContactManagerModel, arguments);
    }
    _inherits(OnCallContactManagerModel, _MgrModel);
    return _createClass(OnCallContactManagerModel, [{
      key: "$getOrdMgrColumnClass",
      value:
      /**
       * Returns the OrdMgrColumn class
       * @private
       * @returns {OrdMgrColumn}
       */
      function $getOrdMgrColumnClass() {
        return OrdMgrColumn;
      }
    }], [{
      key: "make",
      value:
      /**
       * Create a `OnCallListManagerModel` instance with the appropriate columns.
       *
       * @param {baja.Component} onCallList
       * @returns {Promise.<module:nmodule/onCall/rc/wb/model/OnCallListManagerModel>}
       */
      function make(onCallList) {
        return MgrTypeInfo.make([ON_CALL_CONTACT_TYPE]).then(function (newTypes) {
          return new OnCallContactManagerModel({
            columns: COLUMNS,
            componentSource: new ContainerComponentSource({
              container: onCallList,
              filter: ['onCall:OnCallContact']
            }),
            newTypes: newTypes
          });
        });
      }
    }]);
  }(MgrModel);
});
