/**
 * Immediately invoked function to start an applet instance in the Niagara
 * Web Start application. This version for N4 creates a JS object containing
 * the applet information, as creating a dummy Applet DOM element would cause
 * JX browser to actually try to load the plugin.
 *
 * Copyright 2017 Tridium, Inc. All Rights Reserved. 
 */

/*jshint browser: true*/
/*jshint camelcase: false */

(function () {
  "use strict";

  var script = document.currentScript,
      parentDiv = document.getElementById(script.appletDivId),
      appletDiv = document.createElement('div'),
      descriptor = {
        ver: 'N4',
        code: 'WbApplet.class',
        id: 'niagaraApplet',
        width: script.appletWidth,
        height: script.appletHeight,
        params: script.appletParams
      };

  try {
    if (parentDiv) {

      // Create a <div> for the applet. Although it will not contain a DOM element
      // for the applet itself, the Web Start application can use the position
      // of this <div> element to work out how it ought to resize the browser and
      // shell components, for the case where it wants to lay them out side-by-side
      // for a hybrid hx/applet application.

      appletDiv.id = 'applet';
      parentDiv.appendChild(appletDiv);

      // Depending on the load ordering, if the applet was embedded in an 'onload'
      // event, the application might not have loaded its support script yet and have
      // created the view interop functions. If it has, tell the view to load the newly embedded
      // applet. If not, just set the JS descriptor on the global 'niagaraWebstart' object
      // and wait for the view's own loading handlers to pick it up after it has loaded
      // the interop script.

      if (window.niagaraWebStart_onAppletEmbedded) {
        window.niagaraWebStart_onAppletEmbedded(descriptor);
      }
      else {
        window.niagaraWebstart = window.niagaraWebstart || {};
        window.niagaraWebstart.appletDesc = descriptor;
      }
    }
  }
  catch (x) {
    if (window.console) { window.console.log('error embedding applet: ' + x); }
  }
}());