/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */
/* exported doReset, checkPasswords */
/* global sjcl */
function doReset() {
  "use strict";
  var newPass = document.getElementById("new-password").value;
  var confirm = document.getElementById("confirm-password").value;

  if (newPass !== confirm) {
    alert('Passwords do not match.');
    return false;
  }

  // Nuke these textfields just in case a custom template
  // assigned 'name' attributes, which would send these
  // values over the wire in plain text
  document.getElementById("new-password").value = "";
  document.getElementById("confirm-password").value = "";

  var newPassBits = sjcl.codec.utf8String.toBits(newPass);
  var resetToken = sjcl.codec.base64.fromBits(newPassBits);
  document.getElementById("resetToken").value = resetToken;
  document.forms[0].submit();

  return false;
}

function checkPasswords(pwdStrength) {
  "use strict";
  var pw1 = document.getElementById('new-password'),
    pw2 = document.getElementById('confirm-password'),
    submitButton = document.getElementById('login-submit'),
    absPathElement = document.getElementById("absPathBase"),

    pw1Value = pw1.value,
    pw2Value = pw2.value,
    absPathBase = "/",

    pw1pass,
    pw2pass;

  if (absPathElement != null) {
    absPathBase = absPathElement.value;
  }

  var passImg = absPathBase + 'login/pass.png',
    failImg = absPathBase + 'login/fail.png';

  pw1pass = isStrongPassword(pw1Value, pwdStrength);
  pw2pass = pw1Value === pw2Value;

  pw1.style.background = 'url(' + (pw1pass ? passImg : failImg) + ') no-repeat right center';
  pw2.style.background = 'url(' + (pw2pass ? passImg : failImg) + ') no-repeat right center';

  submitButton.disabled = !pw1pass || !pw2pass;
}

function isStrongPassword(arg, pwdStrength) {
  "use strict";
  var upper = 0;
  var lower = 0;
  var digits = 0;
  var special = 0;

  for (var i = 0; i < arg.length; i++) {
    // there will be some discrepancies on how our java implementation detects character types
    // and what we can detect in javascript. Characters without case, like ª will be detected as
    // lowercase letters in java. Foreign digits like ٤ (arabic-indic 4) will be detected as
    // digits in java. Without a full list of characters and types, we cannot guarantee the type
    // of a character that is not uppercase or lowercase and has a character code over 170, so in
    // those cases we will assume the character can be lower, digit, or special. This will allow
    // some passwords that will not be allowed in our java implementation. In those cases, we will
    // be redirected to the reset page with an alert dialog.
    var char = arg.charAt(i);

    // if it is uppercase or lowercase we can guarantee that it is a letter
    if (isUpper(char)) {
      upper++;
    } else if (isLower(char)) {
      lower++;
    } else if (char.charCodeAt(0) >= 170) {
      // if it is not uppercase or lowercase, and the char code >= 170,
      // we have to assume it can be a lowercase letter, digit, or special character
      lower++;
      digits++;
      special++;
    } else if (isDigit(char)) {
      // if it is 0-9, it is a digit
      digits++;
    } else {
    // it is special
      special++;
    }
  }

  return upper >= pwdStrength.minimumUpperCase && lower >= pwdStrength.minimumLowerCase &&
    digits >= pwdStrength.minimumDigits && special >= pwdStrength.minimumSpecial &&
    arg.length >= pwdStrength.minimumLength && arg.length <= pwdStrength.maximumLength;
}

function isUpper(char) {
  "use strict";
  return char === char.toUpperCase() && char !== char.toLowerCase();
}

function isLower(char) {
  "use strict";
  return char === char.toLowerCase() && char !== char.toUpperCase();
}

function isDigit(char) {
  "use strict";
  return /^\d+$/.test(char);
}
