/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/BooleanChangeOfStateAlgorithm
 */
define(['baja!', 'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja, AlarmAlgorithm) {
  'use strict';

  /**
   * BajaScript representation of an `alarm:BooleanChangeOfStateAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/BooleanChangeOfStateAlgorithm
   */
  var BooleanChangeOfStateAlgorithm = function BooleanChangeOfStateAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  BooleanChangeOfStateAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  BooleanChangeOfStateAlgorithm.prototype.constructor = BooleanChangeOfStateAlgorithm;

  /**
   * Merge in facets from the parent point for the `alarmValue` slot.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  BooleanChangeOfStateAlgorithm.prototype.getFacets = function (slot) {
    switch (String(slot)) {
      case 'alarmValue':
        return this.getPointFacets();
      default:
        return AlarmAlgorithm.prototype.getFacets.apply(this, arguments);
    }
  };
  return BooleanChangeOfStateAlgorithm;
});
