/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/EnumCommandFailureAlgorithm
 */
define(['baja!', 'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja, AlarmAlgorithm) {
  'use strict';

  /**
   * BajaScript representation of an `alarm:EnumCommandFailureAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/EnumCommandFailureAlgorithm
   */
  var EnumCommandFailureAlgorithm = function EnumCommandFailureAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  EnumCommandFailureAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  EnumCommandFailureAlgorithm.prototype.constructor = EnumCommandFailureAlgorithm;

  /**
   * Merge in facets from the parent point for the `feedbackValue` slot.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  EnumCommandFailureAlgorithm.prototype.getFacets = function (slot) {
    var f = AlarmAlgorithm.prototype.getFacets.apply(this, arguments);
    switch (String(slot)) {
      case 'feedbackValue':
        return baja.Facets.make(this.getPointFacets(), f);
      default:
        return f;
    }
  };
  return EnumCommandFailureAlgorithm;
});
