/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/SilenceCommand
 */
define(['bajaux/commands/Command', 'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (Command, alarmConsoleCommandMixIn) {
  'use strict';

  /**
   * Silences all the sounds currently playing.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var SilenceCommand = function SilenceCommand(view) {
    Command.apply(this, [{
      module: 'alarm',
      lex: 'commands.silence',
      func: function func() {
        view.$getViewModel().$getAudioQueue().stopAll();
      }
    }]);
    alarmConsoleCommandMixIn(this);
    this.$showInCommandBar = true;
  };
  SilenceCommand.prototype = Object.create(Command.prototype);
  SilenceCommand.prototype.constructor = SilenceCommand;
  return SilenceCommand;
});
