/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/SoundOffCommand
 */
define(['bajaux/commands/ToggleCommand', 'lex!alarm', 'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (ToggleCommand, lexicons, alarmConsoleCommandMixIn) {
  'use strict';

  var lex = lexicons[0];

  /**
   * If selected the sound is all switched off otherwise it's on.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/ToggleCommand}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var SoundOffCommand = function SoundOffCommand(view) {
    ToggleCommand.apply(this, [{
      module: 'alarm',
      lex: 'commands.soundOff',
      func: function func() {
        var state = !view.$getViewModel().$getAudioQueue().isEnabled();
        view.$getViewModel().$getAudioQueue().setEnabled(state);
        view.$getViewModel().$getSupport().setAlarmConsoleOption('soundOff', !state);
        this.setSelected(!state);
      }
    }]);
    alarmConsoleCommandMixIn(this);
    this.$view = view;
  };
  SoundOffCommand.prototype = Object.create(ToggleCommand.prototype);
  SoundOffCommand.prototype.constructor = SoundOffCommand;

  /**
   * Update the state of the toggle command based on the current state
   * of the audio handler.
   */
  SoundOffCommand.prototype.update = function () {
    this.setSelected(!this.$view.$getViewModel().$getAudioQueue().isEnabled());
  };
  SoundOffCommand.prototype.setSelected = function () {
    var newIcon, currentIcon;
    ToggleCommand.prototype.setSelected.apply(this, arguments);
    newIcon = this.isSelected() ? lex.get("commands.soundOff.enabled.icon") : lex.get("commands.soundOff.icon");
    currentIcon = this.getIcon();
    newIcon = newIcon.replace(/^module:\/\//, "/module/");
    if (newIcon !== currentIcon) {
      this.setIcon(newIcon);
    }
  };
  return SoundOffCommand;
});
