/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @since Niagara 4.6
 * @module nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn
 */
define([], function () {
  'use strict';

  /**
   * Adds common alarm console methods to a Command or ToggleCommand.
   *
   * @mixin
   * @param  {module:bajaux/commands/Command|module:bajaux/commands/ToggleCommand} cmd
   * The command object to be mixed.
   */
  return function alarmConsoleCommandMixIn(cmd) {
    /**
     * Invoked when the alarm console selection changes.
     */
    cmd.selectionChanged = cmd.selectionChanged || function () {};

    /**
     * Returns true if the command is to show up in the right click alarm console menu.
     *
     * @returns {Boolean} Returns true if shown in the pop up menu.
     */
    cmd.isShownInMenu = cmd.isShownInMenu || function () {
      return !!this.$showInMenu;
    };

    /**
     * Returns true if shown in the command bar.
     *
     * @returns {Boolean} Returns true if shown in the command bar.
     */
    cmd.isShownInCommandBar = cmd.isShownInCommandBar || function () {
      return !!this.$showInCommandBar;
    };
  };
});
