/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/DefaultColumn
 */
define(['lex!alarm', 'Promise', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/util/textUtils'], function (lexs, Promise, Column, textUtils) {
  'use strict';

  var lex = lexs[0];

  /**
   * DefaultColumn
   *
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/table/model/Column}
   * @alias {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @param {String} name the column name
   */
  var DefaultColumn = function DefaultColumn(name) {
    Column.apply(this, [name, {
      displayName: lex.get({
        key: 'alarm.console.columns.' + name,
        def: textUtils.toFriendly(name)
      })
    }]);
  };
  DefaultColumn.prototype = Object.create(Column.prototype);
  DefaultColumn.prototype.constructor = DefaultColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {jQuery} dom
   * @returns {Promise}
   */
  DefaultColumn.prototype.buildCell = function (row, dom) {
    var str = String(this.getValueFor(row));
    return this.toDisplayName().then(function (displayName) {
      dom.attr("data-cell-prefix", displayName + ": ");
      dom.attr("title", str);
      dom.text(str);
    });
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  DefaultColumn.prototype.getValueFor = function (row) {
    return row.getSubject()[this.getName()];
  };
  return DefaultColumn;
});
