/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/InfoColumn
 */
define(['baja!', 'lex!alarm', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/alarm/rc/console/table/columns/DefaultColumn', 'nmodule/webEditors/rc/util/textUtils'], function (baja, lexs, $, Promise, fe, IconEditor, DefaultColumn, textUtils) {
  'use strict';

  var lex = lexs[0],
    alarmImg = lex.get('alarm.console.columns.icon.alarm'),
    redAlarmImg = lex.get('alarm.console.columns.icon.alarmRed'),
    greenAlarmImg = lex.get('alarm.console.columns.icon.alarmGreen'),
    orangeAlarmImg = lex.get('alarm.console.columns.icon.alarmOrange'),
    whiteAlarmImg = lex.get('alarm.console.columns.icon.alarmWhite'),
    notesImg = lex.get('alarm.console.columns.icon.note'),
    videoImg = lex.get('alarm.console.columns.icon.video'),
    hyperlinkImg = lex.get('alarm.console.columns.icon.hyperlink'),
    imgMap = {
      'a': alarmImg,
      'r': redAlarmImg,
      'g': greenAlarmImg,
      'o': orangeAlarmImg,
      'w': whiteAlarmImg,
      'n': notesImg,
      'v': videoImg,
      'h': hyperlinkImg
    };
  function getIconList(alarm) {
    var sourceState = alarm._sourceState,
      ackState = alarm._ackState,
      facets = alarm.alarmData,
      iconOrd = facets.icon || 'null',
      hyperlinkOrd = facets.hyperlinkOrd || 'null',
      videoOrd = facets.cameraOrd || 'null',
      notes = facets.notes || '',
      icons = [];

    // Standard alarm icons
    if (sourceState === 'alert' && ackState !== 'acked') {
      icons.push("o");
    } else if (sourceState === 'alert' && ackState === 'acked') {
      icons.push("w");
    } else if (sourceState === 'normal' && ackState !== 'acked') {
      icons.push("g");
    } else if (sourceState !== 'normal' && ackState !== 'acked') {
      icons.push("r");
    } else if (sourceState === 'normal' && ackState === 'acked') {
      icons.push("w");
    } else {
      // Default to offnormal and acked icon if no other.
      icons.push("a");
    }

    // Signify notes icon.
    if (notes) {
      icons.push("n");
    }

    // Add custom icon specified from facets.
    if (iconOrd !== 'null') {
      icons.push("c");
    }

    // Display hyperlink icon.
    if (hyperlinkOrd !== 'null') {
      icons.push("h");
    }

    // Display video icon.
    if (videoOrd !== 'null') {
      icons.push("v");
    }
    return icons;
  }

  /**
   * InfoColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/InfoColumn}
   */
  var InfoColumn = function InfoColumn() {
    DefaultColumn.apply(this, ['info', {
      displayName: lex.get({
        key: 'alarm.console.columns.info',
        def: textUtils.toFriendly('info')
      })
    }]);
    this.setHidable(false);
    this.setExportable(false);
  };
  InfoColumn.prototype = Object.create(DefaultColumn.prototype);
  InfoColumn.prototype.constructor = InfoColumn;

  /**
   * @returns {Boolean}
   */
  InfoColumn.prototype.isSortable = function () {
    return false;
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise}
   */
  InfoColumn.prototype.buildCell = function (row, dom) {
    var alarm = row.getSubject(),
      icons = getIconList(alarm),
      len = icons.length,
      alarmData = alarm.alarmData,
      uris = [],
      editors = [],
      key;
    if (len > 0) {
      // Alarm state icon
      key = icons[0];
      uris.push(imgMap[key]);

      // Notes badge
      if (len > 1) {
        key = icons[1];
        if (key === 'n') {
          uris.push(imgMap[key]);
        }
      }
      return fe.buildFor({
        dom: $('<span/>'),
        type: IconEditor,
        value: uris
      }).then(function (ed) {
        editors.push(ed);

        // Additional icons
        return Promise.all(icons.slice(uris.length === 1 ? 1 : 2).map(function (key) {
          var icon = imgMap[key] || String(baja.Ord.make(alarmData.icon).relativizeToSession());
          return fe.buildFor({
            dom: $('<span/>'),
            type: IconEditor,
            value: [icon]
          }).then(function (ed) {
            editors.push(ed);
          });
        })).then(function () {
          for (var i = 0; i < editors.length; i++) {
            dom.append(editors[i].jq());
          }
        });
      });
    }
  };
  return InfoColumn;
});
