/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/AlgorithmEnumEditor
 */
define(['baja!', 'nmodule/alarm/rc/util/alarmUtils', 'nmodule/webEditors/rc/fe/baja/StatusValueEditor', 'css!nmodule/alarm/rc/fe/alarmEditors'], function (baja, alarmUtils, StatusValueEditor) {
  'use strict';

  var getPointFacets = alarmUtils.getPointFacets;

  /**
   * Editor for the `feedbackValue` slot on an
   * `alarm:EnumCommandFailureAlgorithm` value. This editor's only job,
   * really, is to propagate the "range" facet from the containing `EnumPoint`
   * down to the enum selector.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/StatusValueEditor
   * @alias module:nmodule/alarm/rc/fe/AlgorithmEnumEditor
   */
  var AlgorithmEnumEditor = function AlgorithmEnumEditor() {
    return StatusValueEditor.apply(this, arguments);
  };
  AlgorithmEnumEditor.prototype = Object.create(StatusValueEditor.prototype);
  AlgorithmEnumEditor.prototype.constructor = AlgorithmEnumEditor;

  /**
   * Assuming we're editing a slot on an `alarm:AlarmAlgorithm`, pull the
   * facets down from the containing control point.
   *
   * @private
   * @returns {Promise} promise to be resolved with the correct facets.
   */
  AlgorithmEnumEditor.prototype.$getSlotFacets = function () {
    var complex = this.getComplex();
    if (baja.hasType(complex, 'alarm:AlarmAlgorithm')) {
      return getPointFacets(complex);
    }
    return StatusValueEditor.prototype.$getSlotFacets.apply(this, arguments);
  };
  return AlgorithmEnumEditor;
});
