/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 * @since Niagara 4.2
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/fe/TextPartEditor
 */
define(['baja!', 'baja!email:Email,email:TextPart', 'lex!email', 'bajaux/mixin/batchSaveMixin', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'css!nmodule/email/rc/email'], function (baja, types, lexs, batchSaveMixin, $, Promise, _, ComplexCompositeEditor) {
  'use strict';

  var COMMIT_READY = batchSaveMixin.COMMIT_READY;

  /**
   * TextPartEditor is a field editor for a email:TextPart type
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/email/rc/fe/TextPartEditor
   */
  var TextPartEditor = function TextPartEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  TextPartEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  TextPartEditor.prototype.constructor = TextPartEditor;

  /**
   * Returns a reference to the StringEditor for the 'text' property of email:TextPart
   * @private
   * @returns {StringEditor} Editor for the 'text' property
   */
  TextPartEditor.prototype.$getTextEditor = function () {
    return this.getBuilder().getEditorFor('text');
  };

  /**
   * Loads the editor with a value of type 'email:TextPart'
   *
   * @param value instance of type email:TextPart to load
   * @returns {Promise} Promise resolved when editor is loaded or rejected when value
   * of an incorrect type is loaded
   */
  TextPartEditor.prototype.doLoad = function (email) {
    if (!baja.hasType(email, 'email:TextPart')) {
      throw new Error('Expected type email:TextPart');
    }
    return ComplexCompositeEditor.prototype.doLoad.apply(this, arguments);
  };
  TextPartEditor.prototype.doSave = function (diff, params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      prom = diff.apply(this.value(), {
        batch: batch
      });
    if (progressCallback) {
      progressCallback(COMMIT_READY);
    }
    return prom;
  };

  ///////////////////////////////////////////////////////////////////
  //ComplexCompositeEditor overrides
  //////////////////////////////////////////////////////////////////
  TextPartEditor.prototype.getSlotFilter = function () {
    return ['text'];
  };
  TextPartEditor.prototype.makeBuilder = function () {
    var builder = ComplexCompositeEditor.prototype.makeBuilder.apply(this, arguments);
    builder.getConfigFor = function () {
      return {
        properties: {
          multiLine: true
        },
        formFactor: 'mini'
      };
    };
    return builder;
  };
  return TextPartEditor;
});
