function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailAuthenticationColumn
 */
define(['lex!email', 'Promise', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (lex, Promise, PropertyMgrColumn) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    emailLexicon = _lex[0];

  /**
   * Manager column for the `emailAuthenticator` property.
   *
   * @class
   * @alias module:nmodule/email/rc/mgr/EmailAuthenticationColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var EmailAuthenticationColumn = function EmailAuthenticationColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  EmailAuthenticationColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  EmailAuthenticationColumn.prototype.constructor = EmailAuthenticationColumn;

  /**
   * Override to return a description of the authentication mechanism configured for the given account.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise} resolves when the cell has been built
   */
  EmailAuthenticationColumn.prototype.buildCell = function (row, dom) {
    var authenticator = this.getValueFor(row);
    var _String$split = String(authenticator.getTypeSpec()).split(':'),
      _String$split2 = _slicedToArray(_String$split, 2),
      authenticatorType = _String$split2[1];
    var authTypeDescription = emailLexicon.get("EmailAccountManager.EmailClientAuthenticator.".concat(authenticatorType));
    return Promise.resolve(dom.text(authTypeDescription));
  };
  return EmailAuthenticationColumn;
});
