function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/ItemCollectionDetailsWidget
 */
define(['jquery', 'Promise', 'baja!', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/nss/rc/fe/ItemsArrayCompositeEditor', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/fe/SeverityWidget', 'nmodule/nss/rc/util/securityDashboardUtil', 'log!nmodule.nss.rc.fe.ItemCollectionDetailsWidget', 'lex!nss'], function ($, Promise, baja, Widget, fe, BaseWidget, ItemsArrayCompositeEditor, CountsBySeverityWidget, ItemCollection, SeverityWidget, securityDashboardUtil, log, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
    nssLex = _lexicon[0];
  var isLinkable = securityDashboardUtil.isLinkable;
  var logSevere = log.severe.bind(log);
  var tpl = function tpl() {
    return "\n      <div class=\"EntityContainer\" >\n        <span class=\"entityIcon\"></span>\n        <span class=\"entityName\"></span> \n      </div>\n      <div>\n        <div class=\"CountsBySeverityWidget\"></div>\n      </div>\n      <div class=\"ItemsContainer\"></div>\n     ";
  };

  /**
   * Shows information about ItemCollection, Severity and Entity.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/ItemCollectionDetailsWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function ItemCollectionDetailsWidget() {
      _classCallCheck(this, ItemCollectionDetailsWidget);
      return _callSuper(this, ItemCollectionDetailsWidget, arguments);
    }
    _inherits(ItemCollectionDetailsWidget, _BaseWidget);
    return _createClass(ItemCollectionDetailsWidget, [{
      key: "doInitialize",
      value:
      /**
       * Adds `ItemCollectionDetailsWidget` class.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.html(tpl()).addClass('ItemsCollectionDetailsWidget');
        dom.on('click', '.entityNameLink', function () {
          dom.trigger(BaseWidget.VALUE_READY_EVENT);
          _this.$doHyperlink();
          return false;
        });
        dom.on('severityFilterChanged', '.CountsBySeverityWidget', function (e, ed, activeFilters) {
          _this.$applyFilterOnItemCollectionDetailsWidget(activeFilters)["catch"](logSevere);
        });
        return Promise.all([new CountsBySeverityWidget({
          properties: {
            horizontal: true
          }
        }).initialize(dom.find('.CountsBySeverityWidget')), new ItemsArrayCompositeEditor().initialize(dom.find('.ItemsContainer')), new SeverityWidget().initialize(dom.find('.entityIcon'))]);
      }

      /**
       * Hyperlink to the ORD of this item collection's source.
       * @private
       */
    }, {
      key: "$doHyperlink",
      value: function $doHyperlink() {
        securityDashboardUtil.hyperlink(this.value().getSourceEntity().getOrd(), this.$getBaseOrd());
      }

      /**
       * Creates the ItemCollectionDetailWidget for the input ItemCollection
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection
       * @returns {Promise} Rendered ItemCollectionDetailWidget wrapped as a
       * Promise (or) a error if the input is not an ItemCollection type.
       */
    }, {
      key: "doLoad",
      value: function doLoad(itemCollection) {
        if (!(itemCollection instanceof ItemCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.itemCollection.type.required.error'));
        }
        return this.$resolveWidgets(itemCollection);
      }

      /**
       * Creates the ItemCollectionDetailWidget for the input ItemCollection
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection
       * @returns {Promise} Rendered ItemCollectionDetailWidget wrapped as a
       * Promise
       */
    }, {
      key: "$resolveWidgets",
      value: function $resolveWidgets(itemCollection) {
        var maxSeverity = itemCollection.getMaxSeverity();
        var sourceEntity = itemCollection.getSourceEntity();
        var ord = baja.Ord.make(sourceEntity.getOrd());
        var entityName = this.jq().find('.entityName');
        if (isLinkable(ord)) {
          entityName.html($('<a class="entityNameLink"/>').text(sourceEntity.getDisplayName()).attr('href', ord.toUri()).attr('data-ord', ord));
        } else {
          entityName.text(sourceEntity.getDisplayName());
        }
        return Promise.all([this.$getCountsBySeverityWidget().load(itemCollection.getCountsBySeverity()), this.$getItemsContainerWidget().load(itemCollection.getItems()), maxSeverity && this.$getSeverityWidget().load(maxSeverity)]);
      }

      /**
       * @private
       * @returns {string|baja.Ord}
       */
    }, {
      key: "$getBaseOrd",
      value: function $getBaseOrd() {
        return this.properties().getValue('baseOrd');
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/CountBySeverityWidget}
       */
    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.jq().find('.CountsBySeverityWidget'));
      }

      /**
       * @private
       * @return {module:nmodule/nss/rc/fe/ItemsArrayCompositeEditor}
       */
    }, {
      key: "$getItemsContainerWidget",
      value: function $getItemsContainerWidget() {
        return Widget["in"](this.jq().find('.ItemsContainer'));
      }

      /**
       * @private
       * @return {module:nmodule/nss/rc/fe/SeverityWidget}
       */
    }, {
      key: "$getSeverityWidget",
      value: function $getSeverityWidget() {
        return Widget["in"](this.jq().find('.entityIcon'));
      }

      /**
       * loads the filtered itemList into the item collection details widget.
       * @private
       * @param {module:nmodule/nss/rc/model/Severity[]} activeFilters - array of Severity Object
       * @return {Promise} re-rendering ItemCollectionDetailWidget wrapped as a
       * Promise
       */
    }, {
      key: "$applyFilterOnItemCollectionDetailsWidget",
      value: function $applyFilterOnItemCollectionDetailsWidget(activeFilters) {
        var itemCollection = this.value();
        return this.$getItemsContainerWidget().load(itemCollection.getItems(activeFilters));
      }

      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ItemsCollectionDetailsWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseWidget);
});
