function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SourceCollectionWidget
 **/
define(['jquery', 'Promise', 'underscore', 'baja!', 'bajaux/Widget', 'bajaux/mixin/responsiveMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/nss/rc/fe/SourceOverviewWidget', 'nmodule/nss/rc/fe/SourceCollectionCompositeEditor', 'nmodule/nss/rc/model/SourceCollection', 'log!nmodule.nss.rc.fe.SourceOverviewWidget', 'nmodule/nss/rc/fe/SourceCollectionCompositeEditor', 'lex!nss'], function ($, Promise, _, baja, Widget, responsiveMixIn, fe, BaseWidget, SourceOverviewWidget, SourceCollectionCompositeEditor, SourceCollection, log, CountsBySeverityWidget, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
    nssLex = _lexicon[0];
  var logSevere = log.severe.bind(log);
  var tpl = function tpl() {
    return "\n      <div class=\"DashboardTitle\">\n        <span><h2 class=\"title\"></h2></span>\n        <span class=\"Timestamp\"></span>\n      </div>\n      <div class=\"SourceCollItemCollectionContainer\">\n      </div>\n     ";
  };

  /**
   * Shows the complete dashboard that has ItemCollectionSummaryWidgets and
   * SourceOverviewWidget
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/SourceCollectionWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function SourceCollectionWidget() {
      var _this;
      _classCallCheck(this, SourceCollectionWidget);
      _this = _callSuper(this, SourceCollectionWidget, arguments);
      responsiveMixIn(_this, {
        'responsive-xxs': {
          maxWidth: 560
        },
        'responsive-xs': {
          maxWidth: 679
        },
        'responsive-sm': {
          minWidth: 680
        },
        'responsive-md': {
          minWidth: 1080
        },
        'responsive-lg': {
          minWidth: 1440
        },
        'responsive-xlg': {
          minWidth: 1890
        }
      });
      return _this;
    }

    /**
     * Adds `ItemCollectionSummaryWidget` and `SourceOverviewWidget` class.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(SourceCollectionWidget, _BaseWidget);
    return _createClass(SourceCollectionWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(tpl()).addClass('SourceCollectionWidget');
        dom.on('severityFilterChanged', '.SourceOverviewWidget', function (e, ed, activeFilters) {
          _this2.$applyFilterOnItemCollectionSummaryWidget(activeFilters)["catch"](logSevere);
        });
        var itemSummariesWidget = new SourceCollectionCompositeEditor({
          properties: this.properties().subset('dashboardService', 'baseOrd').toValueMap()
        });
        return itemSummariesWidget.initialize(dom.find('.SourceCollItemCollectionContainer'));
      }

      /**
       * Creates the SourceCollectionWidget for the input sourceCollection
       * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection
       * @returns {Promise} Rendered SourceCollectionWidget wrapped as a
       * Promise (or) a error if the input is not an ItemCollection type.
       */
    }, {
      key: "doLoad",
      value: function doLoad(sourceCollection) {
        var _this3 = this;
        if (!(sourceCollection instanceof SourceCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.type.required.error'));
        }
        var cardsWidget = this.$getSourceCollectionArrayWidget();
        var baseOrd = sourceCollection.getSourceEntity().getOrd();
        cardsWidget.properties().add('baseOrd', baseOrd);
        return cardsWidget.load([sourceCollection].concat(sourceCollection.getItemCollections())).then(function () {
          var displayName = sourceCollection.getSourceEntity().getDisplayName();
          _this3.jq().find('.DashboardTitle .title').text(displayName);
          var timestamp = sourceCollection.getTimestamp();
          if (timestamp) {
            var relTime = baja.RelTime.make(timestamp - new Date());
            var timestampElement = _this3.jq().find('.DashboardTitle .Timestamp');
            return relTime.toFriendlyString().then(function (intervalString) {
              timestampElement.text(nssLex.get('SecurityDashboardView.sourceCollection.timestampLabel', intervalString));
            });
          }
        });
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SourceOverviewWidget}
       */
    }, {
      key: "$getSourceOverviewWidget",
      value: function $getSourceOverviewWidget() {
        return Widget["in"](this.jq().find('.SourceOverviewWidget'));
      }

      /**
       * CountsBySevWidgetContainer will be emitted.
       * @private
       * @return {Widget}
       */
    }, {
      key: "$getSourceCollectionArrayWidget",
      value: function $getSourceCollectionArrayWidget() {
        return Widget["in"](this.jq().find('.SourceCollItemCollectionContainer'));
      }

      /**
       * loads the filtered itemList into the item collection summary widget.
       * @private
       * @param {module:nmodule/nss/rc/model/Severity[]} activeFilters - array of Severity Object
       * @returns {Promise} loads itemContainer with filtered itemList
       */
    }, {
      key: "$applyFilterOnItemCollectionSummaryWidget",
      value: function $applyFilterOnItemCollectionSummaryWidget(activeFilters) {
        this.jq().toggleClass('filter-show-none', activeFilters.length === 0);
        return Promise.all(_.map(this.jq().find('.ItemCollectionSummaryWidget'), function (itemCollectionSummaryDom) {
          var itemCollectionSummaryWidget = Widget["in"](itemCollectionSummaryDom);
          return itemCollectionSummaryWidget.applyFilter(activeFilters);
        }));
      }

      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('filter-show-none');
        this.jq().removeClass('SourceCollectionWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseWidget);
});
