function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/ItemCollection
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Item', 'nmodule/nss/rc/model/Severity', 'nmodule/nss/rc/util/securityDashboardUtil', 'nmodule/webEditors/rc/mixin/DataMixin', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'lex!nss'], function (Entity, Item, Severity, securityDashboardUtil, DataMixin, typeUtils, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0];
  var isArrayOf = typeUtils.isArrayOf;
  var isArrayOfSeverities = isArrayOf.bind(null, Severity);

  /**
   * @private
   * @param {module:nmodule/nss/rc/model/Severity[]} severities
   * @param {module:nmodule/nss/rc/model/Item[]} sortedItems, sorted items by Severity
   * @returns {module:nmodule/nss/rc/model/Item[]} returned items after sorting as per the order
   */
  function processSeverities(severities, sortedItems) {
    var severitiesToQuery = [];
    var itemsToReturn = [];
    severities.forEach(function (severity) {
      if (severitiesToQuery.indexOf(severity.getName()) === -1) {
        severitiesToQuery.push(severity.getName());
      }
    });
    var uniqueSortedSeverityNames = [];
    sortedItems.forEach(function (item) {
      if (uniqueSortedSeverityNames.indexOf(item.getSeverity().getName()) === -1) {
        uniqueSortedSeverityNames.push(item.getSeverity().getName());
      }
    });
    uniqueSortedSeverityNames.forEach(function (name) {
      if (severitiesToQuery.indexOf(name) !== -1) {
        var filteredItems = securityDashboardUtil.filterBySeverityName(sortedItems, name);
        itemsToReturn = itemsToReturn.concat(filteredItems);
      }
    });
    return itemsToReturn;
  }

  /**
   * A collection of security dashboard items from one individual source, such
   * as a UserService, or one station in a supervisor rollup.
   *
   * @class
   * @alias module:nmodule/nss/rc/model/ItemCollection
   * @mixes module:nmodule/webEditors/rc/mixin/DataMixin
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.entity source entity for list of Item
   * @param {module:nmodule/nss/rc/model/Item[]} [params.items=[]] list of items of type Item, default will be an empty array
   * @param {Date | null} [params.timestamp=null] should be null if generated from a station; returns Date if generated from a supervisor rollup
   * @throws {Error} if items, entity, or timestamp are missing
   */
  return /*#__PURE__*/function () {
    function ItemCollection() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        entity = _ref.entity,
        _ref$items = _ref.items,
        items = _ref$items === void 0 ? [] : _ref$items,
        _ref$timestamp = _ref.timestamp,
        timestamp = _ref$timestamp === void 0 ? null : _ref$timestamp;
      _classCallCheck(this, ItemCollection);
      if (!(entity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.entity.required.error'));
      }
      if (!this.$isValidItemList(items)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.items.required.error'));
      }
      if (!(timestamp === null || timestamp instanceof Date)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.date.invalid'));
      }
      this.$items = items || [];
      this.$entity = entity;
      this.$timestamp = timestamp;
      DataMixin(this, {
        status: ItemCollection.status.COMPLETE
      });
    }
    return _createClass(ItemCollection, [{
      key: "$isValidItemList",
      value:
      /**
       * @private
       * @param {module:nmodule/nss/rc/model/Item[]} itemsList is list of items of type Item
       * @returns {boolean} true if itemList is valid and false on invalid
       */
      function $isValidItemList(itemsList) {
        if (itemsList) {
          if (Array.isArray(itemsList)) {
            return itemsList.every(function (item) {
              return item instanceof Item;
            });
          } else {
            return false;
          }
        }
        return true;
      }

      /**
       * @returns {module:nmodule/nss/rc/model/Entity} Entity related to all the
       * items in the itemsList
       */
    }, {
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$entity;
      }

      /**
       * @param {module:nmodule/nss/rc/model/Severity[]} severities is optional,
       * pass in optional array of Severity
       * @returns {module:nmodule/nss/rc/model/Item[]} after sorting
       * objects to get items that only match the Severities,
       * sort results by Severity, highest first
       */
    }, {
      key: "getItems",
      value: function getItems(severities) {
        var allItems = this.$items;
        var sortedItems = securityDashboardUtil.sortByPriority(allItems);
        if (severities) {
          if (isArrayOfSeverities(severities)) {
            return processSeverities(severities, sortedItems);
          } else {
            return [];
          }
        } else {
          return sortedItems;
        }
      }

      /**
       * @returns {number} total count of items
       */
    }, {
      key: "getItemCount",
      value: function getItemCount() {
        return this.$items.length;
      }

      /**
       * @returns {Object[]} severityMapObject - where each entry has a Severity object to give
       * the severity details like, icon, name and display name, and count property says the count
       * of severities, and returns empty array when there are no Item in the list.
       */
    }, {
      key: "getCountsBySeverity",
      value: function getCountsBySeverity() {
        var _this = this;
        var allItems = securityDashboardUtil.sortByPriority(this.$items);
        var uniqueSeveritiesName = [];
        var severityMapObject = [];
        allItems.forEach(function (item) {
          var severityName = item.getSeverity().getName();
          if (uniqueSeveritiesName.indexOf(severityName) === -1) {
            uniqueSeveritiesName.push(severityName);
            severityMapObject.push(_this.$getSeverityReferenceAndCount(item.getSeverity()));
          }
        });
        return severityMapObject;
      }

      /**
       * @param {module:nmodule/nss/rc/model/Severity} severityObj the criteria to filter by priority
       * @returns {Object} count based on severities
       */
    }, {
      key: "$getSeverityReferenceAndCount",
      value: function $getSeverityReferenceAndCount(severityObj) {
        var allItems = this.$items;
        var filteredItems = securityDashboardUtil.filterBySeverity(allItems, severityObj);
        return {
          severity: filteredItems[0].getSeverity(),
          count: filteredItems.length
        };
      }

      /**
       * @returns {Severity | undefined } the maximum Severity in the total list of Items
       * or undefined, if there are no Item in the itemList
       */
    }, {
      key: "getMaxSeverity",
      value: function getMaxSeverity() {
        if (this.$items.length > 0) {
          var allItems = this.$items;
          var sortedItems = securityDashboardUtil.sortByPriority(allItems);
          return sortedItems[0].getSeverity();
        }
      }

      /**
       * @returns {Date | null} the timestamp at which this collection of items was generated
       */
    }, {
      key: "getTimestamp",
      value: function getTimestamp() {
        return this.$timestamp;
      }
    }], [{
      key: "status",
      get: function get() {
        /**
         * Enumerated status of an individual ItemCollection. In a system view,
         * ItemCollections come from individual stations, which can go down or take
         * a while to return results. In the case of PENDING the UI may want to
         * wait a bit and then poll again until the ItemCollection comes back
         * COMPLETE.
         *
         * @private
         * @readonly
         * @enum
         * @name module:nmodule/nss/rc/model/ItemCollection.status
         */
        return {
          /** Item collection has a complete set of data from the server and fit for display. */
          COMPLETE: 'COMPLETE',
          /** Actual data is still in the process of building on the server; user needs to wait a bit longer. */
          PENDING: 'PENDING',
          /** Data could not be retrieved for this one particular source. */
          FAILED: 'FAILED',
          /** No new data to report - continue to display the existing data with no changes. */
          UP_TO_DATE: 'UP_TO_DATE'
        };
      }
    }]);
  }();
});
