/*
Child widgets
=============

A child widget can be specified just like an HTML tag can.

By default, child widgets will be created in a <div> tag. You can specify a
different kind of tag using the tagName attribute.

In addition, this example shows that a spandrel widget can return an array of
elements, not just one element. Remember that a bajaux Widget is initialize()d
into a single DOM element, but may define its structure however it likes. By
returning an array of elements, you can define multiple child elements of your
widget's own DOM element.
*/

/** @jsx spandrel.jsx */

define([ 'bajaux/spandrel' ], function (spandrel) {

  'use strict';
  
  const PropertyRow = spandrel((prop) => [
    <td>{prop.getName()}</td>,
    <td>{String(prop.getType())}</td>
  ]);

  const PropertyListWidget = spandrel((comp) => (
    <table class="ux-table">
      <thead class="ux-table-head">
        <tr>
          <th>Name</th><th>Type</th>
        </tr>
      </thead>
      <tbody>
      {
        comp.getSlots().properties().toArray().map((prop) => {
          /*
          For each of these property rows, something like this is happening behind the scenes.
          spandrel handles the details for you:

          const dom = $('<tr class="ux-table-row" />').appendTo(tbody);
          const widget = new PropertyRow();
          return widget.initialize(dom)
            .then(() => widget.load(prop));
           */
          return <PropertyRow tagName="tr" className="ux-table-row" value={ prop } />;
        })
      }
      </tbody>
    </table>
  ));

  return PropertyListWidget;
});
