/* eslint-env browser */

/*
Customized widget behavior
==========================

Remember that spandrel widgets are themselves bajaux Widgets. Therefore, you are
free to extend from spandrel widgets and customize their behavior.

The "class * extends spandrel()" pattern is very common. Use it to define widget
defaults or change behavior as needed.

Here, we will implement doRead() so that the current value of the spandrel
widget can be read out. We will also arm some event handlers in doInitialize (a
very standard pattern in bajaux widgets); but in an upcoming example we will
look at some other, spandrel-specific ways of handling events.

Point this example at a slot of type baja:Number, such as
station:|slot:/SpandrelExamples/Simples/double.
*/

/** @jsx spandrel.jsx */

define([ 'bajaux/spandrel' ], function (spandrel) {

  'use strict';

  class SliderWidget extends spandrel((number) => {
    return <span>
      <input type="range" min="0" max="100" value={ number } />
      <label className="currentValue">{ String(number) }</label>
    </span>;
  }) {
    doInitialize(dom) {
      dom.on('change', () => {
        this.read()
          .then((currentValue) => this.jq().find('.currentValue').text(currentValue))
          .catch((err) => console.error(err));
      });

      // when overriding doInitialize, it is important for a spandrel widget to
      // always call super. but it should be rare that a spandrel widget would
      // *need* to override doInitialize. see an upcoming example on event
      // handling.
      return super.doInitialize(...arguments);
    }

    doRead() {
      return +this.jq().find('input').val();
    }
  }

  return SliderWidget;
});
