/*
spandrel basics
===============

spandrel is a library, introduced in Niagara 4.10, to help you build bajaux
Widgets. Its status is Development, so it may still change in future versions of
Niagara.

A spandrel widget allows you to build the structure of your widget (HTML and
child widgets) in a more declarative way. The basic Widget API requires you to
write the code to build out the HTML and initialize and load child widgets
yourself, but spandrel allows you to simply declare, "this is what I want my
widget to look like." spandrel handles the details of building out the structure
for you.

The first argument to the spandrel function is what defines "what my widget
looks like" and can take several forms. The simplest possible form is just a
string of HTML.

This widget is referred to as a "static" spandrel widget, because its structure
never changes - it just builds itself out once, and that's it. You do not need
to load a value into it.

The spandrel() function returns a Widget constructor which you may initialize
and load just like any other Widget subclass.
*/

define([ 'bajaux/spandrel' ], function (spandrel) {
  'use strict';

  const HelloWorldWidget = spandrel('<span style="color: blue;">Hello world!</span>');

  return HelloWorldWidget;
});
