function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/FontEditor
 */
define(['baja!', 'baja!gx:Font', 'lex!gx', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'Promise', 'nmodule/gx/rc/baja/Font', 'css!nmodule/gx/rc/gx'], function (baja, types, lexs, _, events, spandrel, Promise, Font) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0],
    boldLabel = "%lexicon(gx:fontFE.bold)%",
    underLineLabel = "%lexicon(gx:fontFE.underline)%",
    italicLabel = "%lexicon(gx:fontFE.italic)%",
    nullLabel = "%lexicon(gx:fontFE.null)%",
    widgetDefaults = function widgetDefaults() {
      return {
        properties: {
          rootCssClass: '-t-FontEditor'
        }
      };
    },
    bajaHasType = baja.hasType;
  var sizeList = "8;9;10;11;12;14;16;18;20;22;24;26;28;36;48;72";
  var fontList = "";
  var once = _.once;
  var loadFonts = once(function () {
    return baja.rpc({
      typeSpec: "gx:GxRpc",
      method: "getFontList",
      args: []
    }).then(function (dataList) {
      if (!dataList.contains("SansSerif")) {
        dataList.push("SansSerif");
      }
      if (!dataList.contains("Serif")) {
        dataList.push("Serif");
      }
      dataList.sort(function (a, b) {
        return a.toLowerCase().localeCompare(b.toLowerCase());
      });
      fontList = dataList.join(";");
    });
  });

  /**
   * A field editor for selecting of valid fonts.
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/FontEditor
   * @extends module:bajaux/Widget
   */
  var FontEditor = /*#__PURE__*/function (_spandrel) {
    function FontEditor(params) {
      var _this;
      _classCallCheck(this, FontEditor);
      _this = _callSuper(this, FontEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$isFontString = false;
      return _this;
    }

    /**
     * @private
     * @param {string|module:nmodule/gx/rc/baja/Font} font
     * @param {object} state
     * @returns {object}
     */
    _inherits(FontEditor, _spandrel);
    return _createClass(FontEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(font, state) {
        // If the input value for font is not a font assume string and decode it
        if (!bajaHasType(font, "gx:Font")) {
          font = Font.make(font);
        }
        var name = state.name,
          size = state.size,
          bold = state.bold,
          italic = state.italic,
          underline = state.underline,
          isNull = state.isNull;
        var tdPreview = document.createElement("td"),
          divPreview = document.createElement("div"),
          tdCheckBox = "<td class=\"-t-FontEditor-checkbox\"></td>";
        tdPreview.classList.add("-t-FontEditor-fontPreview");
        tdPreview.setAttribute("rowspan", "2");
        divPreview.innerText = gxLex.get("fontFE.previewText");
        tdPreview.appendChild(divPreview);
        font.applyToElement(divPreview);
        switch (name.toLowerCase()) {
          case 'sans-serif':
            name = 'SansSerif';
            break;
          case 'monospace':
            name = 'Monospaced';
            break;
          default:
            break;
        }
        if (isNull) {
          name = '';
          size = '';
          bold = false;
          italic = false;
          underline = false;
        }
        return {
          layoutTable: {
            dom: '<table></table>',
            kids: {
              row1: {
                dom: '<tr></tr>',
                kids: {
                  fontName: {
                    bindKey: 'name',
                    dom: '<td colspan="3" class="-t-FontEditor-fontName"></td>',
                    value: name,
                    lax: true,
                    enabled: !isNull,
                    properties: {
                      datalist: fontList,
                      filterWhileTyping: false
                    }
                  },
                  fontSize: {
                    bindKey: 'size',
                    dom: '<td class="-t-FontEditor-fontSize"></td>',
                    value: size,
                    lax: true,
                    enabled: !isNull,
                    properties: {
                      datalist: sizeList,
                      filterWhileTyping: false
                    }
                  },
                  fontPreview: {
                    dom: tdPreview
                  }
                }
              },
              row2: {
                dom: '<tr></tr>',
                kids: {
                  fontBold: {
                    bindKey: 'bold',
                    dom: tdCheckBox,
                    value: bold,
                    lax: true,
                    enabled: !isNull,
                    properties: {
                      displayType: 'checkbox',
                      trueText: boldLabel,
                      falseText: boldLabel
                    }
                  },
                  fontUnderline: {
                    bindKey: 'underline',
                    dom: tdCheckBox,
                    value: underline,
                    lax: true,
                    enabled: !isNull,
                    properties: {
                      displayType: 'checkbox',
                      trueText: underLineLabel,
                      falseText: underLineLabel
                    }
                  },
                  fontItalics: {
                    bindKey: 'italic',
                    dom: tdCheckBox,
                    value: italic,
                    lax: true,
                    enabled: !isNull,
                    properties: {
                      displayType: 'checkbox',
                      trueText: italicLabel,
                      falseText: italicLabel
                    }
                  },
                  fontNull: {
                    bindKey: 'isNull',
                    dom: tdCheckBox,
                    value: isNull,
                    properties: {
                      displayType: 'checkbox',
                      trueText: nullLabel,
                      falseText: nullLabel
                    }
                  }
                }
              }
            }
          }
        };
      }
    }, {
      key: "toState",
      value: function toState(font) {
        var asString = typeof font === 'string';
        if (asString) {
          font = Font.make(font);
        }
        var isNull = font.isNull();
        if (isNull) {
          // start with default values if null is loaded
          font = Font.DEFAULT;
        }
        return {
          name: font.getName(),
          size: String(font.getSize()),
          bold: font.isBold(),
          italic: font.isItalic(),
          underline: font.isUnderline(),
          isNull: isNull,
          asString: asString
        };
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var name = state.name,
          size = state.size,
          bold = state.bold,
          italic = state.italic,
          underline = state.underline,
          isNull = state.isNull,
          asString = state.asString;
        var font;
        if (isNull) {
          font = Font.NULL;
        } else if (name === Font.NULL.getName() || !name) {
          font = Font.DEFAULT;
        } else {
          font = Font.make({
            name: name,
            size: +size,
            bold: bold,
            italic: italic,
            underline: underline
          });
        }
        return asString ? font.encodeToString() : font;
      }
    }, {
      key: "$getFontNameWidget",
      value: function $getFontNameWidget() {
        return this.queryWidget('layoutTable/row1/fontName');
      }
    }, {
      key: "$getFontSizeWidget",
      value: function $getFontSizeWidget() {
        return this.queryWidget('layoutTable/row1/fontSize');
      }
    }, {
      key: "$getFontBoldWidget",
      value: function $getFontBoldWidget() {
        return this.queryWidget('layoutTable/row2/fontBold');
      }
    }, {
      key: "$getFontUnderlineWidget",
      value: function $getFontUnderlineWidget() {
        return this.queryWidget('layoutTable/row2/fontUnderline');
      }
    }, {
      key: "$getFontItalicsWidget",
      value: function $getFontItalicsWidget() {
        return this.queryWidget('layoutTable/row2/fontItalics');
      }
    }, {
      key: "$getFontNullWidget",
      value: function $getFontNullWidget() {
        return this.queryWidget('layoutTable/row2/fontNull');
      }
    }, {
      key: "$getFontPreviewWidget",
      value: function $getFontPreviewWidget() {
        return this.queryWidget('layoutTable/row1/fontPreview');
      }
    }]);
  }(spandrel(function (font, state) {
    var _this2 = this;
    return loadFonts().then(function () {
      return _this2.$buildEditor(font, state);
    });
  }, {
    strategy: 'niagara'
  }));
  return FontEditor;
});
