/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/ElapsedActiveTimeAlarmAlgorithm
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets,
    timeFacet = baja.Facets.make({
      showDate: false,
      showMilliseconds: false
    });

  /**
   * BajaScript representation of a `kitControl:ElapsedActiveTimeAlarmAlgorithm` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/ElapsedActiveTimeAlarmAlgorithm}
   */
  var ElapsedActiveTimeAlarmAlgorithm = function ElapsedActiveTimeAlarmAlgorithm() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^errorLimit$': timeFacet
    });
  };
  ElapsedActiveTimeAlarmAlgorithm.prototype = Object.create(Component.prototype);
  ElapsedActiveTimeAlarmAlgorithm.prototype.constructor = ElapsedActiveTimeAlarmAlgorithm;
  return ElapsedActiveTimeAlarmAlgorithm;
});
