/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusEnumToInt
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:StatusEnumToInt` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusEnumToInt}
   */
  var StatusEnumToInt = function StatusEnumToInt() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^in$': 'inFacets',
      '^out$': 'outFacets'
    });
  };
  StatusEnumToInt.prototype = Object.create(StatusValueToValue.prototype);
  StatusEnumToInt.prototype.constructor = StatusEnumToInt;

  //TODO: needs issue logged: cannot override a slot accessor method on subclass
  /**
   * Return the value of the `outFacets` slot.
   *
   * @returns {baja.Facets}
   */
  StatusEnumToInt.prototype.getOutFacets = function () {
    return this.get('outFacets');
  };
  return StatusEnumToInt;
});
