/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/OutsideAirOptimization
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:OutsideAirOptimization` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/OutsideAirOptimization}
   */
  var OutsideAirOptimization = function OutsideAirOptimization() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^((in|out)sideTemp|lowTemperatureLimit)$': 'temperatureFacets',
      '^(in|out)sideHumidity$': 'humidityFacets'
    });
  };
  OutsideAirOptimization.prototype = Object.create(Component.prototype);
  OutsideAirOptimization.prototype.constructor = OutsideAirOptimization;
  return OutsideAirOptimization;
});
