/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/DecaInputNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:DecaInputNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/util/DecaInputNumeric}
   */
  var DecaInputNumeric = function DecaInputNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  DecaInputNumeric.prototype = Object.create(Component.prototype);
  DecaInputNumeric.prototype.constructor = DecaInputNumeric;
  return DecaInputNumeric;
});
